package com.ejie.p06b.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import com.ejie.p06b.log.P06BLog;

public class P06bConnector {

	/**
	 * Constructor por defecto
	 */
	private P06bConnector() {
	}

	/**
	 * Abre una conexin a base de datos
	 * 
	 * @param parametros
	 *            : Objeto de tipo Properties con los parmetros de
	 *            configuracin de la conexin
	 * 
	 * @return Devuelve un objeto Connection con la conexin a base de datos ya
	 *         abierta
	 * 
	 * @throws Exception
	 *             : Lanza un objeto de tipo Exception en caso de haber existido
	 *             algn problema
	 */
	public static Connection openConnection(Properties parametros) throws NamingException, SQLException {

		InitialContext ctx = null;
		DataSource ds = null;
		try{
			Hashtable ht = new Hashtable();
			ht.put(Context.INITIAL_CONTEXT_FACTORY,
					parametros.getProperty("mediadoresSeguros.ejb.initialContextFactory"));
			ht.put(Context.PROVIDER_URL, parametros.getProperty("mediadoresSeguros.ejb.providerUrl"));
			ctx = new InitialContext(ht);
			P06BLog.send(0,P06bConnector.class, "(openConnection) Obtenido InitialContext");
			ds = (DataSource) ctx.lookup(parametros.getProperty("p06b.datasource"));
			P06BLog.send(0,P06bConnector.class, "(openConnection) Obtenido dataSource");
		}catch (NamingException ne){
			P06BLog.send(0,P06bConnector.class, "(openConnection) Error al obtener initialContext o dataSource. INITIAL_CONTEXT_FACTORY: '"
							+ parametros.getProperty("mediadoresSeguros.ejb.initialContextFactory")
							+ "', PROVIDER_URL: '"
							+ parametros.getProperty("mediadoresSeguros.ejb.providerUrl")
							+ "', DATASOURCE: '"
							+ parametros.getProperty("p06b.datasource") + "'");
			throw (ne);
		}
		Connection conn = null;
		try{
			conn = ds.getConnection();
			P06BLog.send(0,P06bConnector.class, "(openConnection) Conexin abierta correctamente");
		}catch (SQLException SQLe){
			P06BLog.send(0,P06bConnector.class, "(openConnection) Error al intentar abrir la conexin. INITIAL_CONTEXT_FACTORY: '"
							+ parametros.getProperty("mediadoresSeguros.ejb.initialContextFactory")
							+ "', PROVIDER_URL: '"
							+ parametros.getProperty("mediadoresSeguros.ejb.providerUrl")
							+ "', DATASOURCE: '"
							+ parametros.getProperty("p06b.datasource") + "'");
			throw (SQLe);
		}
		return conn;
	}

	/**
	 * Cierra una conexin a base de datos
	 * 
	 * @param conn
	 *            : Objeto de tipo Connection con la conexin a base de datos a
	 *            cerrar
	 * 
	 * @throws SQLException
	 *             : Lanza un objeto de tipo SQLException en caso de haber
	 *             existido algn problema
	 */
	public static void closeConnection(Connection conn) throws SQLException {
		P06BLog.send(0,P06bConnector.class, "(closeConnection) Cerrando la conexin");
		if (conn != null) {
			conn.close();
			P06BLog.send(0,P06bConnector.class, "(closeConnection) Conexin cerrada correctamente");
		}
	}
	
}
